#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

vector<int> najblizi_desno(const vector<int>& h) {
	int n = h.size();
	vector<int> ngr(n);
	vector<int> st;

	for (int i = n - 1; i >= 0; i--) {
		while (!st.empty() and h[st.back()] < h[i]) st.pop_back();
		ngr[i] = st.empty() ? -1 : st.back();
		st.push_back(i);
	}
	return ngr;
}

vector<int> najblizi_levo(const vector<int>& h) {
	int n = h.size();
	vector<int> ngl(n);
	vector<int> st;

	for (int i = 0; i < n; i++) {
		while (!st.empty() and h[st.back()] < h[i]) st.pop_back();
		ngl[i] = st.empty() ? -1 : st.back();
		st.push_back(i);
	}
	return ngl;
}

int main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	int n; cin >> n;
	vector<pair<int, int>> jarboli(n);

	for (int i = 0; i < n; i++) cin >> jarboli[i].first;
	for (int i = 0; i < n; i++) cin >> jarboli[i].second;

	sort(jarboli.begin(), jarboli.end());

	vector<int> x(n), h(n);
	for (int i = 0; i < n; i++) {
		x[i] = jarboli[i].first;
		h[i] = jarboli[i].second;
	}

	vector<int> ngr = najblizi_desno(h);
	vector<int> ngl = najblizi_levo(h);

	for (int i = 0; i < n; i++) {
		int desni_indeks = ngr[i], levi_indeks = ngl[i];
		int rastojanje_levo = levi_indeks == -1 ? INT_MAX : x[i] - x[levi_indeks] - (h[levi_indeks] - h[i]);
		int rastojanje_desno = desni_indeks == -1 ? INT_MAX : x[desni_indeks] - x[i] - (h[desni_indeks] - h[i]);

		if (levi_indeks == -1 and desni_indeks == -1) cout << -1 << endl;
		else cout << min(rastojanje_levo, rastojanje_desno) << endl;
	}

	return 0;
}